#ifndef __ADRENALIN__FTNSTRUC__HEADER__
#define __ADRENALIN__FTNSTRUC__HEADER__

// uncomment definition below if you have AKA addresses
// in this case you should also define AKA[] in Msg.cpp
// #define HAVE_AKA

const MAX_DOMAIN_SIZE = 20;
const MAX_AREA_SIZE   = 96;  // Maximum area name size (with '\0')
const MAX_KLUDGE_SIZE = 512; // Maximum kludge line size
const MAX_FLAG_SIZE   = 20;  // Maximum flag size of ^AFLAGS kludge

typedef unsigned char  uint8;
typedef unsigned short uint16;
typedef unsigned long  uint32;
typedef signed char    int8;
typedef signed short   int16;
typedef signed long    int32;

typedef unsigned short addr;

const ATTR_PRIVATE            = 1,
      ATTR_CRASH              = 2,
      ATTR_RECEIVED           = 4,
      ATTR_SENT               = 8,
      ATTR_FILE_ATTACHED      = 16,
      ATTR_TRANSIT            = 32,
      ATTR_ORPHAN             = 64,
      ATTR_KILL_SENT          = 128,
      ATTR_LOCAL              = 256,
      ATTR_HOLD_FOR_PICKUP    = 512,
      // 1024 is unused
      ATTR_FILE_REQ           = 2048,
      ATTR_RETURN_RECEIPT_REQ = 4096,
      ATTR_IS_RETURN_RECEIPT  = 8192,
      ATTR_AUDIT_REQ          = 16384,
      ATTR_FILE_UPDATE_REQ    = 32768,
      // flags
      FLAG_DIRECT             = 1,
      FLAG_IMMEDIATE          = 2,
      FLAG_KILL_FILE_SENT     = 4,
      FLAG_TRUNCATE_FILE      = 8,
      FLAG_LOCK               = 16,
      FLAG_CONFIRM_REQ        = 32,
      // BSO flags
      BSO_NORMAL              = 0,
      BSO_CRASH               = 1,
      BSO_DIRECT              = 2,
      BSO_HOLD                = 4,
      BSO_IMMEDIATE           = 8,
      BSO_KILL_FILE_SENT      = 16,
      BSO_TRUNCATE_FILE       = 32,
      BSO_IRNORE              = 64,
      BSO_TYPE                = 15,  // mask for BSO ?ut type
      BSO_LINE_TYPE           = 112; // mask for BSO ?lo line type
          
#pragma pack(push, 1)

const int	MSG_NAME_LENGTH    = 36;
const int	MSG_SUBJECT_LENGTH = 72;

struct SMsgHeader {
    char   m_szFromUserName[MSG_NAME_LENGTH];
    char   m_szToUserName[MSG_NAME_LENGTH];
    char   m_szSubject[MSG_SUBJECT_LENGTH];
    char   m_szDateTime[20];
    uint16 m_wTimesRead;
    addr   m_wDestNode;
    addr   m_wOrigNode;
    uint16 m_wCost;
    addr   m_wOrigNet;
    addr   m_wDestNet;
    addr   m_wDestZone;
    addr   m_wOrigZone;
    addr   m_wDestPoint;
    addr   m_wOrigPoint;
    uint16 m_wReplyTo;
    uint16 m_wAttrs;
    uint16 m_wNextReply;
};

struct SPackedMsgHeader {
    uint16 MsgID; // 0002h
    addr   OrigNode;
    addr   DestNode;
    addr   OrigNet;
    addr   DestNet;
    uint16 Attrs;
    uint16 Cost;
    char   DateTime[20];
};

struct SPktHeader {
    addr   OrigNode;
    addr   DestNode;
    uint16 Year;
    uint16 Month;
    uint16 Day;
    uint16 Hour;
    uint16 Minute;
    uint16 Second;
    uint16 Baud;
    uint16 PacketType;
    addr   OrigNet;
    addr   DestNet;
    uint8  ProdCode;
    uint8  SerialNo;
    char   Password[8];
    addr   OrigZone;
    addr   DestZone;
    char   Fill[20];
};

#pragma pack(pop)

struct SFTNAddress {
    addr	Zone;
    addr	Net;
    addr	Node;
    addr	Point;
    TCHAR	Domain[MAX_DOMAIN_SIZE];
    /* Prints the address in format zone:net/node[.point]@domain
     */
	tstring	toString() const;

	tstring toShortestString(const SFTNAddress& baseAddr) const;

    void	ToString(LPTSTR szBuf) const;
    void	ToStringWithoutDomain(LPTSTR szBuf) const;
    SFTNAddress&	operator =(const SFTNAddress& addr);
    SFTNAddress() : Zone(0), Net(0), Node(0), Point(0) { Domain[0] = _T('\0'); }
    SFTNAddress(const SFTNAddress& addr) { this->operator =(addr); }

	bool operator ==(const SFTNAddress& addr);
};
typedef SFTNAddress* PAddress;

int ParseFTNAddress(const char *s, SFTNAddress &Address);
int AddrCmp(const SFTNAddress &Addr1,const SFTNAddress &Addr2 );

#endif
